; SIGIL
; a 32-byte intro by rrrola
; intended for DOSBox (fast BIOS putpixel in 1024x768 mode)

; greets to everyone who still writes there super-tiny intros

; DESCRIPTION
; It's a random walk with hexagonal symmetry.

; Keep a pixel position in [CX=x, DX=y].
; Rotate it around the center [R,R] in 6 steps:
;   x -> R+x-y -> 2R-y -> 2R-x -> R-x+y -> y -> x
; Sometimes nudge x to x-1 based on a random state in DI.
;   We can nudge only to the left, but we keep rotating around the center
;   so the position can effectively move in all 6 direction.
; The position also feeds back to the random state.
;   It's similar to a LFSR, but it's intentionally not too random
;   to get many kinds of patterns: lines, wavy paths, 3D mazes, and noise.
; When x=0, we pick a new pixel color based on the current y.

org 100h  ; assume ax=0 cx=0xff si=0x100 di=sp=0xfffe [sp]=0

  add ax,0x4f02                                        ;05 02 4f
P add cx,[si] ; rotation center R = 0x0205 = 517       ;03 0c
  pop dx      ; on init: dx=0                  colors:{;5a
  and dh,3    ; keep position on screen               {;80 e6 03

  mov bx,0x105; on init: set VESA mode 1024x768, 256 colors, al=4F (blue)
  int 0x10    ; later: draw pixel at [cx,dx] (al=color, bh=ignored page=1)

  sub di,cx   ; adjust random state in di based on position
  sub di,dx
  add di,di   ; set carry

  loop C      ; cx -= 1
  mov al,dh   ; if cx=0, change color to {sand=5a, blue=80, dirt=e6, cyan=03}
  xlat        ; color = [bx+dh], keep carry

C push cx     ; rotate around the center in 6 steps
  sbb cx,dx   ; [x, y] = [x-y+R-carry, x]

  mov ah,0x0c ; int 0x10 - draw putpixel

  jmp P

